<!DOCTYPE html>
<html lang="en">

<?php
session_start();
?>
<head>
    <title>TOPSIS v2</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>

    <script>
    function submitted(event) {
      event.preventDefault();
      document.getElementById("inputAlt").removeAttribute('required');
      document.getElementById("inputCrit").removeAttribute('required');
      document.getElementById("myForm").submit();
    }
  </script>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: 'Lato', sans-serif;
      font-family: 'Oswald', sans-serif;
    }

    .wrapper {
      position: fixed;
      top: 0;
      right: -100%;
      height: 100%;
      width: 100%;
      background: #000;
      transition: all 0.6s ease-in-out;
      text-align: center;
    }

    #active:checked~.wrapper {
      right: 0;
    }

    .menu-btn {
      position: absolute;
      z-index: 2;
      right: 20px;
      top: 20px;
      height: 50px;
      width: 50px;
      text-align: center;
      line-height: 50px;
      border-radius: 50%;
      font-size: 20px;
      cursor: pointer;
      transition: all 0.3s ease-in-out;
    }

    .menu-btn span,
    .menu-btn:before,
    .menu-btn:after {
      content: "";
      position: absolute;
      top: 20%;
      left: 30%;
      width: 40%;
      border-bottom: 2px solid #fff;
      transition: transform .6s cubic-bezier(0.215, 0.61, 0.355, 1);
    }

    .menu-btn:before {
      transform: translateY(-8px);
    }

    .menu-btn:after {
      transform: translateY(8px);
    }


    .close {
      z-index: 1;
      width: 100%;
      height: 100%;
      pointer-events: none;
      transition: background .6s;
    }

    /* closing animation */
    #active:checked+.menu-btn span {
      transform: scaleX(0);
    }

    #active:checked+.menu-btn:before {
      transform: rotate(45deg);
      border-color: #fff;
    }

    #active:checked+.menu-btn:after {
      transform: rotate(-45deg);
      border-color: #fff;
    }

    .wrapper ul {
      position: absolute;
      top: 60%;
      left: 50%;
      height: 90%;
      transform: translate(-50%, -50%);
      list-style: none;
      text-align: center;
    }

    .wrapper ul li {
      height: 10%;
      margin: 15px 0;
      text-align: center;
    }

    .wrapper ul li a {
      text-decoration: none;
      font-size: 30px;
      font-weight: 500;
      padding: 5px 30px;
      color: #fff;
      border-radius: 50px;
      position: absolute;
      line-height: 50px;
      margin: 5px 30px;
      opacity: 0;
      transition: all 0.3s ease;
      transition: transform .6s cubic-bezier(0.215, 0.61, 0.355, 1);
    }

    .wrapper ul li a:after {
      position: absolute;
      content: "";
      background: #fff;
      width: 100%;
      height: 100%;
      left: 0;
      top: 0;
      border-radius: 50px;
      transform: scaleY(0);
      z-index: -1;
    }

    .wrapper ul li a:hover:after {
      transform: scaleY(1);
    }

    .wrapper ul li a:hover {
      color: #1a73e8;
    }

    input[type="checkbox"] {
      display: none;
    }

    .content {
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      z-index: -1;
      text-align: center;
      width: 100%;
      color: #202020;
    }

    .content .title {
      font-size: 40px;
      font-weight: 600;
    }

    .content p {
      font-size: 35px;
      font-weight: 500;
    }

    #active:checked~.wrapper ul li a {
      opacity: 1;
    }

    .wrapper ul li a {
      transition: opacity 1.2s, transform 1.2s cubic-bezier(0.215, 0.61, 0.355, 1);
      transform: translateX(100px);
    }

    #active:checked~.wrapper ul li a {
      transform: none;
      transition-timing-function: ease, cubic-bezier(.1, 1.3, .3, 1);
      /* easeOutBackを緩めた感じ */
      transition-delay: .6s;
      transform: translateX(-100px);
    }

    .custom-badge {
      width: 200px;
      /* Adjust the width as needed */
      height: 50px;
      /* Adjust the height as needed */
      font-size: 50px;
    }

    .nav-item {
      font-size: 20px;
    }

    .navbar-brand {
      font-size: 17px;
    }
  </style>
  <link href="https://fonts.googleapis.com/css2?family=Oswald&display=swap" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Lato&display=swap" rel="stylesheet">
  <script src="https://kit.fontawesome.com/a076d05399.js"></script>
</head>

<body>
    <?php
    // session_start();
    // Database connection settings
    $host = 'localhost';
    $dbname = 'steffan';
    $username = 'root';
    $password = '';

    $_POST['savedTemplateList'] = null;

    $disabled = '';
    if (isset($_SESSION['ranking'])) { //Ketika Ranking sudah keluar, variabel $disabled akan bernilai disable. 
        $disabled = ' disabled';

        $_POST['listKriteria'] = $_SESSION['kriteria'];
        $_POST['listBobot'] = $_SESSION['bobot'];
        $_POST['listAlternatif'] = $_SESSION['alternatif'];
        $_POST['listLokasi'] = $_SESSION['lokasi'];
        $_POST['listNilai'] = $_SESSION['nilai'];
        $_POST['jumlahKriteria'] = count($_POST['listKriteria']);
        $_POST['jumlahAlternatif'] = count($_POST['listAlternatif']);
    } else {
        $disabled = '';
    }

    try {
        // Establish database connection
        $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
        // Set PDO to throw exceptions on errors
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        // Prepare and execute SQL query
        $stmt = $pdo->query('SELECT * FROM savedtemplates');
        // Fetch data as associative array
        $_POST['savedTemplateList'] = $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        // Handle database connection errors
        echo "Connection failed: " . $e->getMessage();
    }

    if (isset($_POST['reset'])) { //Ketika Reset diklik, maka lakukan unset untuk seluruh variabel
        unset($_POST['jumlahAlternatif']);
        unset($_POST['jumlahKriteria']);
        unset($_POST['listKriteria']);
        unset($_POST['listBobot']);
        unset($_POST['listBobot']);
        unset($_POST['listLokasi']);
        unset($_POST['listNilai']);
        unset($_POST['reset']);
        unset($_FILES);

        unset($_POST['loadTemplate']);
        unset($_SESSION['ranking']);
    }

    if (isset($_POST['loadTemplate'])) { //Untuk load template

        $selectedTemplate = searchById($_POST['loadTemplate'])[0];

        $array[] = explode(",", $selectedTemplate['kriteria_bobot']);
        $explodedAlternatifLokasi = explode(",", $selectedTemplate['alternatif_lokasi']);
        for ($i = 0; $i < count($explodedAlternatifLokasi); $i += 2) {
            $array[] = [$explodedAlternatifLokasi[$i], $explodedAlternatifLokasi[$i + 1]];
        }

        loadDataToPostVariable($array);
    }

    if (isset($_POST['saveTemplateName'])) { //Untuk save template
    }

    // Function to search for elements with the same ID
    function searchById($id): array
    {
        $result = [];
        foreach ($_POST['savedTemplateList'] as $item) {
            if ($item['id'] == $id) {
                $result[] = $item;
            }
        }
        return $result;
    }

    function loadDataToPostVariable(array $array): void
    {
        // GET THE KRITERIA AND BOBOT ON INDEX 0 / ON FIRST LINE ON CSV
        // FORMAT FIRST LINE CSV IS LIKE THIS => A,1,B,2,C,3
        $kriteria = $bobot = [];
        foreach ($array[0] as $key => $value) {
            if ($key % 2 == 0) {
                $kriteria[] = $value;
            } else {
                $bobot[] = $value;
            }
        }

        //REMOVE FIRST DATA SO CAN ITERATE THE DATA ONLY
        unset($array[0]);

        $alternatif = $lokasi = $nilai = [];
        foreach ($array as $subArray) {
            array_push($alternatif, $subArray[0]);
            array_push($lokasi, $subArray[1]);
            array_push($nilai, array_slice($subArray, 2));
        }

        $_POST['jumlahKriteria'] = count($kriteria);
        $_POST['jumlahAlternatif'] = count($alternatif);
        $_POST['listKriteria'] = $kriteria;
        $_POST['listBobot'] = $bobot;
        $_POST['listAlternatif'] = $alternatif;
        $_POST['listLokasi'] = $lokasi;
        $_POST['listNilai'] = $nilai;

    }

    ?>
    <nav class="navbar navbar-expand-sm bg-dark navbar-dark">
    <div class="container-fluid">
      <ul class="navbar-nav">
        <li class="nav-item">
          <a class="nav-link active" href="">RANKING</a>
        </li>
      </ul>
    </div>
  </nav>
    <div class="row">
        <div class="col-1"></div>
        <div class="col-10">
            <!-- Header -->
            <div class="row">
                <div class="col-12">
                    <br>
                    <h3>TOPSIS Method</h3>
                </div>
            </div>
            <!-- Form -->
            <div>
                <div class="row">
                    <div class="col-12">
                        <form method="POST">
                            <label>Jumlah Alternatif (Min. 2)
                                <input type="number" class="form-control" min="2" name="jumlahAlternatif" required>
                            </label>
                            <label>Jumlah Kriteria (Min. 2)
                                <input type="number" class="form-control" min="2" name="jumlahKriteria" required>
                            </label>
                    </div>
                </div>
                <div class="row mt-2">
                    <div class="col-12 d-flex">
                        <button class="btn btn-primary me-2" type="submit">Submit</button>
                        </form>
                        <form method="POST">
                            <input type="hidden" name="reset" value="true">
                            <button class="btn btn-danger" type="submit">Reset</button>
                        </form>
                    </div>
                </div>
            </div>
            <!-- Form CSV-->
            <div>
                <div class="row mt-4">
                    <div class="col-12">
                        <h5>Upload CSV File</h5>
                    </div>
                </div>
                <div class="row">
                    <div class="col-12">
                        <form method="POST" enctype="multipart/form-data" class="d-flex">
                            <input type="file" id="csvFile" name="csvFile" accept=".csv">
                            <button class="btn btn-info">Load CSV</button>
                        </form>
                    </div>
                </div>
                <?php
                if (isset($_FILES['csvFile']) && $_FILES['csvFile']['tmp_name']) {

                    //DECODE CSV
                    $csvData = [];
                    $file = fopen($_FILES['csvFile']['tmp_name'], 'r');
                    while (($line = fgetcsv($file)) !== false) {
                        array_push($csvData, $line);
                    }
                    fclose($file);

                    loadDataToPostVariable($csvData);
                } ?>
            </div>
            <!-- Select FROM DB-->
            <div class="mt-4">
                <div class="row">
                    <div class="col-12">
                        <h5>Select From DB</h5>
                    </div>
                </div>
                <div class="row">
                    <div class="col-3">
                        <form method="POST" class="d-flex">
                            <select name="loadTemplate" id="loadTemplate" class="form-select form-select text-dark me-2">
                                <option value="">--Select--</option>
                                <?php
                                if ($_POST['savedTemplateList']) {
                                    foreach ($_POST['savedTemplateList'] as $key => $value) {
                                        echo '<option value="' . $value['id'] . '">' . $value['nama'] . '</option>';
                                    }
                                }
                                ?>
                            </select>
                            <button class="btn btn-primary" type="submit">Load</button>
                        </form>
                    </div>
                    <div class="col-3">
                        <form method="POST" class="d-flex" id="deleteTemplate">
                            <select name="deleteTemplateId" id="deleteTemplate" class="form-select form-select text-dark me-2">
                                <option value="">--Select--</option>
                                <?php
                                if ($_POST['savedTemplateList']) {
                                    foreach ($_POST['savedTemplateList'] as $key => $value) {
                                        echo '<option value="' . $value['id'] . '">' . $value['nama'] . '</option>';
                                    }
                                }
                                ?>
                            </select>
                            <button class="btn btn-danger" id="deleteDataOnDB">Delete</button>
                        </form>
                    </div>
                    <div class="col-3">

                    </div>
                </div>
            </div>
            <!-- Table -->
            <div class="row mt-4
                <?php
                if ((isset($_POST['jumlahAlternatif']) && isset($_POST['jumlahKriteria'])) || isset($_SESSION['ranking'])) {
                    if (isset($_SESSION['ranking'])){
                        // $_POST['nilai'] = $_SESSION['nilai'];
                        // $_POST['bobot'] = $_SESSION['bobot'];
                        // $_POST['listKriteria'] = $_SESSION['listKriteria'];
                        // $_POST['listAlternatif'] = $_SESSION['listAlternatif'];
                    }
                    echo '';
                } else {
                    echo ' d-none';
                }
                ?> ">
                <form method="POST" action="step1.php" id="tableData">
                    <div class="row">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>
                                        <input type="text" placeholder="Nama template" name="namaTemplate" class="form-control">
                                        <button class="btn btn-success" id="saveToDBButton">Save To DB</button>
                                    </th>
                                    <th>
                                        <h6 id="response" class="d-none"></h6>
                                    </th>
                                </tr>
                                <tr>
                                    <th rowspan="2" class="align-middle text-center">List Alternative</th>
                                    <?php
                                    if (isset($_POST['jumlahAlternatif']) && isset($_POST['jumlahKriteria'])) {
                                        for ($i = 0; $i < $_POST['jumlahKriteria']; $i++) {
                                            if (isset($_POST['listKriteria']) && isset($_POST['listBobot'])) {
                                                echo '
                                                <th>
                                                    <input type="text" class="form-control" placeholder="Kriteria ' . ($i + 1) . '" name="kriteria[' . $i . ']" value="' . ($_POST['listKriteria'][$i]) . '" required ' . $disabled . ' >
                                                    <input type="number" step="any" class="form-control" placeholder="Bobot ' . ($i + 1) . '" name="bobot[' . $i . ']" min="0" value="' . ($_POST['listBobot'][$i]) . '" required ' . $disabled . '>
                                                </th>
                                                ';
                                            } else {
                                                echo '
                                                <th>
                                                    <input type="text" class="form-control" placeholder="Kriteria ' . ($i + 1) . '" name="kriteria[' . $i . ']" required ' . $disabled . '>
                                                    <input type="number" step="any" class="form-control" placeholder="Bobot ' . ($i + 1) . '" name="bobot[' . $i . ']" min="0" required ' . $disabled . '>
                                                </th>
                                                ';
                                            }
                                        }
                                    }
                                    ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                if (isset($_POST['jumlahAlternatif']) && isset($_POST['jumlahKriteria'])) {
                                    for ($i = 0; $i < $_POST['jumlahAlternatif']; $i++) {
                                        if (isset($_POST['listAlternatif']) && isset($_POST['listLokasi'])) {
                                            echo '
                                            <tr>
                                                <td>
                                                    <input type="text" class="form-control" placeholder="Alternatif ' . ($i + 1) . '" name="alternatif[' . $i . ']" value="' . ($_POST['listAlternatif'][$i]) . '"  ' . $disabled . '>
                                                    <input type="text" class="form-control" placeholder="Location ' . ($i + 1) . '" name="lokasi[' . $i . ']" value="' . ($_POST['listLokasi'][$i]) . '"  ' . $disabled . '>
                                                </td>
                                            ';
                                        } else {
                                            echo '
                                            <tr>
                                                <td>
                                                    <input type="text" class="form-control" placeholder="Alternatif ' . ($i + 1) . '" name="alternatif[' . $i . ']"  ' . $disabled . '>
                                                    <input type="text" class="form-control" placeholder="Location ' . ($i + 1) . '" name="lokasi[' . $i . ']"  ' . $disabled . '>
                                                </td>
                                            ';
                                        }
                                        for ($j = 0; $j < $_POST['jumlahKriteria']; $j++) {
                                            if (isset($_POST['listNilai'][0]) && count($_POST['listNilai'][0])) {
                                                echo '
                                                <td><input type="number" class="form-control" placeholder="Nilai ' . ($j + 1) . '" name="nilai[' . $i . '][' . $j . ']" value="' . ($_POST['listNilai'][$i][$j]) . '"  ' . $disabled . '></td>
                                                ';
                                            } else {
                                                echo '
                                                <td><input type="number"  class="form-control" placeholder="Nilai ' . ($j + 1) . '" name="nilai[' . $i . '][' . $j . ']"  ' . $disabled . '></td>
                                                ';
                                            }
                                        }
                                        echo '</tr>';
                                    }
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="row">
                        <button class="btn btn-primary" type="submit">Calculate</button>
                    </div>
                </form>
            </div>
            <!-- Results -->
            <?php
            if (isset($_SESSION['ranking'])) {
                echo '
            <div class="mt-4">
                <div class="row">
                    <h5>Results</h5>
                </div>
                <div class="row">
                    <div class="col-12">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Ranking</th>
                                    <th>Alternatif</th>
                                    <th>Skor</th>
                                    <th>Link Lokasi</th>
                                </tr>
                            </thead>
                            <tbody>
                        ';
            } ?>
            <?php
            if (isset($_SESSION["ranking"])) {
                $ranking = $_SESSION["ranking"];
                $counter = 0;
                foreach ($ranking as $index => $rank) {
                    $locationLink = $_SESSION["loc"][($index + 2)];
                    if (!preg_match("~^(?:f|ht)tps?://~i", $locationLink)) {
                        // If not, prepend with http:// (you might need to adjust this based on your data)
                        $locationLink = "http://" . $locationLink;
                    }
                    echo "<tr>";
                    echo "<td>", $rank, "</td>";
                    echo "<td>", $_SESSION['cell'][($index + 2)][1], "</td>";
                    echo "<td>", $_SESSION['skortopsis'][$counter], "</td>";
                    echo "<td><a href='{$locationLink}' target='_blank'>Visit Location</a></td>";
                    echo "</td>";
                    $counter++;
                }
            } ?>
            <?php
            if (isset($_SESSION['ranking'])) {
                echo '
                            </tbody>
                            </table>
                        </div>
                    </div>
                    </div>
                    <div class="row">
                    <div class="col-12">
                        <a class="btn btn-secondary" href="downloadvar.php">Download Table as CSV</a>
                        <a class="btn btn-secondary" href="downloadcsv.php">Download Result as CSV</a>
                    </div>
                </div>
                ';
            } ?>
        </div>
        <div class="col-1"></div>
    </div>
</body>

<script>
    document.getElementById('saveToDBButton').addEventListener('click', function(event) {
        event.preventDefault();

        var form = document.getElementById('tableData');
        var formData = new FormData(form);

        fetch('save_to_db.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.text())
            .then(data => {
                // document.getElementById('response').innerText = data;
                alert("Data saved successfully!");
            })
            .catch(error => console.error('Error:', error));
    });

    document.getElementById('deleteDataOnDB').addEventListener('click', function(event) {
        event.preventDefault();
        
        var form = document.getElementById('deleteTemplate');
        var formData = new FormData(form);

        fetch('delete_data.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.text())
            .then(data => {
                // document.getElementById('response').innerText = data;
                alert("Data Deleted!");
                location.reload(); 
            })
            .catch(error => console.error('Error:', error));
    });
</script>



</html>